<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Mdl_expenses
 */
class Mdl_expenses extends Response_Model
{
    public $table = 'pd_expenses';
    public $primary_key = 'pd_expenses.expense_id';

    public function default_select()
    {
        $query = $this->db->select('ipx.expense_id, ipx.expense_name, ipx.expense_status, ipx.expense_date_created, COUNT(ipi.item_id) AS item_count, SUM(ipi.item_total) AS total_amount')
    ->from('pd_expenses ipx')
    ->join('pd_expense_items ipi', 'ipx.expense_id = ipi.expense_id', 'left')
    ->group_by('ipx.expense_id');

    return $query;

    }
    public function get_company() {
        $email =$this->session->userdata('user_email');
        $this->db->select('*');
        $this->db->from('pd_users');
        $this->db->where('user_email', $email); // Add this line to filter active clients
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array(); // Empty array if no results
        } 
    }

    public function expenseItems(){
        return $this->db->query('SELECT ipx.expense_id, ipx.expense_name, ipx.expense_status, ipx.expense_date_created, COUNT(ipi.item_id) AS item_count, SUM(ipi.item_total) AS total_amount FROM pd_expenses ipx LEFT JOIN pd_expense_items ipi ON ipx.expense_id = ipi.expense_id GROUP BY ipx.expense_id;')->result_array();
    }

    public function insert_expense($data) {
        // Insert item into database
        return $this->db->insert('pd_expenses', $data);
    }

    public function get_expenses($expense_id) {
        $this->db->select('*');
        $this->db->from('pd_expenses');
        $this->db->where('pd_expenses.expense_id', $expense_id);
        $query = $this->db->get();
        return $query->result_array();
    }



    public function update_expense($expense_id, $expense_data) {
        $this->db->where('expense_id', $expense_id);
        $this->db->update('pd_expenses', $expense_data);

        // Check if the update was successful
        if ($this->db->affected_rows() > 0) {
            return true; // Update successful
        } else {
            return false; // Update failed
        }
    }



    public function default_order_by()
    {
        $this->db->order_by('pd_expenses.expense_name');
    }



    public function statuses()
    {
        return array(
            '1' => array(
                'label' => trans('draft'),
                'class' => 'draft',
                'href' => 'expense/status/draft'
            ),
            '2' => array(
                'label' => trans('sent'),
                'class' => 'sent',
                'href' => 'expense/status/sent'
            ),
            '3' => array(
                'label' => trans('viewed'),
                'class' => 'viewed',
                'href' => 'expense/status/viewed'
            ),
            '4' => array(
                'label' => trans('paid'),
                'class' => 'paid',
                'href' => 'expense/status/paid'
            )
        );
    }


    public function by_expense($match)
    {
        $this->db->group_start();
        $this->db->like('pd_expenses.expense_name', $match);
        $this->db->or_like('pd_expenses.expense_description', $match);
        $this->db->or_like('pd_expenses.expense_vendor', $match);
        $this->db->group_end();
    }

    public function by_family($match)
    {
        $this->db->where('pd_expenses.expense_category', $match);
    }

    /**
     * @return array
     */
    public function validation_rules()
    {
        return array(

            'expense_name' => array(
                'field' => 'expense_name',
                'label' => trans('expense_name'),
                'rules' => 'required'
            ),
            'expense_date' => array(
                'field' => 'expense_date',
                'label' => trans('expense_date'),
                'rules' => ''
            ),
        );
    }



    /**
     * @return array
     */
    public function db_array()
    {
        $db_array = parent::db_array();

        $db_array['expense_amount'] = (empty($db_array['expense_amount']) ? null : standardize_amount($db_array['expense_amount']));
        $db_array['expense_category'] = (empty($db_array['expense_category']) ? null : $db_array['expense_category']);

        return $db_array;
    }

    public function is_sumex()
    {
        $this->where('sumex_id is NOT NULL', null, false);
        return $this;
    }

    /**
     * @param int $invoice_id
     */
    public function delete($expense_id)
    {
        parent::delete($expense_id);

        $this->load->helper('orphan');
        delete_orphans();
    }

    public function delete_items($expense_id){

        $this->db->where('expense_id',$expense_id);
        $this->db->delete('pd_expense_items');
    }


}
